TITLE   'Radiating and Conducting Semicircular Foil'         { exa173.pde }
SELECT     							
   errlim=1e-4     spectral_colors     stages=16
VARIABLES   U   temp
DEFINITIONS
   r1=0.2     r2=0.4     d=1e-4            			{ New geometry }
   U1=stage*0.1     k=400     temp0=300
   cond0=1/1.67e-8     cond=cond0*temp0/abs(temp)    	
   Ex=-dx(U)     Ey=-dy(U)     E=-grad(U)     Em=magnitude(E)
   Jx=cond*Ex     Jy=cond*Ey     J=cond*E     Jm=cond*Em
   fluxd_x=-k*dx(temp)     fluxd_y=-k*dy(temp)
   fluxd=vector( fluxd_x, fluxd_y)     fluxdm=magnitude( fluxd)
   heat=Jm*Em- 2* 0.3*  5.67e-8* (temp^4-300^4)/d	
	   	       { 2 faces, emissivity, Stefan-Boltzmann formula  }
INITIAL VALUES
   U=0   temp=400
EQUATIONS
   U: 		div( J)=0
   temp:	div( fluxd)=heat
BOUNDARIES
region 'domain'
   start (-r2,0)  value(U)=U1/2  value(temp)=300  line to (-r1,0)
   natural(U)=0  natural(temp)=0  arc to (0,r1) to (r1,0)
   value(U)= -U1/2  value(temp)=300  line to (r2,0)
   natural(U)=0  natural(temp)=0  arc to (0,r2) close
MONITORS
   contour( cond)
PLOTS
   contour( temp) painted     surface( temp)		
   contour( U) painted     contour( Em) painted
   contour( Jm) painted     vector( J) norm
END




